//=============================================================================
// Weapon9A91.
//=============================================================================
class Weapon9A91 extends MarkistanCityGuns;

//+++++++++++++
//Icons
//+++++++++++++
#exec TEXTURE IMPORT NAME=BeltIcon9a91 FILE=Textures\BeltIcon9a91FIN.PCX GROUP=Icons //Belt
#exec TEXTURE IMPORT NAME=InventoryIcon9a91 FILE=Textures\InventoryIcon9a91FIN.PCX GROUP=Icons //Inventory

//-------------
//Sounds
//-------------
#exec AUDIO IMPORT FILE="C:\DeusEx\MarkistanCity\Sounds\SMGFire.wav" NAME="SMGFire" GROUP="Weapons"
#exec AUDIO IMPORT FILE="C:\DeusEx\MarkistanCity\Sounds\RifleReload3.wav" NAME="SMGReload" GROUP="Weapons"
#exec AUDIO IMPORT FILE="C:\DeusEx\MarkistanCity\Sounds\RifleReload1.wav" NAME="SMGReloadEnd" GROUP="Weapons"

//================================
// Pickup
//================================

#exec MESH IMPORT MESH=9a91pickup ANIVFILE=MODELS\9a91pickup_a.3d DATAFILE=MODELS\9a91pickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=9a91pickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=9a91pickup SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=9a91pickup SEQ=9a91Pickup STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=9aGrayAlloy FILE=Textures\9aGrayAlloy.PCX GROUP=Skins // Gray
#exec TEXTURE IMPORT NAME=9aLightGrayAlloy FILE=Textures\9aLightGrayAlloy.PCX GROUP=Skins // Light Gray
#exec TEXTURE IMPORT NAME=9aDarkGrayAlloy FILE=Textures\9aDarkGrayAlloy.PCX GROUP=Skins // Dark Gray
#exec TEXTURE IMPORT NAME=9aBlackAlloy FILE=Textures\BlackAlloy.PCX GROUP=Skins // Black
#exec TEXTURE IMPORT NAME=DERP9aCusMuz FILE=Textures\CusMuz.PCX GROUP=Skins // Yellow

#exec MESHMAP NEW   MESHMAP=9a91pickup MESH=9a91pickup
//#exec MESHMAP SCALE MESHMAP=9a91pickup X=0.008594025 Y=0.008594025 Z=0.008594025
#exec MESHMAP SCALE MESHMAP=9a91pickup X=0.01031283 Y=0.01031283 Z=0.01031283

#exec MESHMAP SETTEXTURE MESHMAP=9a91pickup NUM=0 TEXTURE=9aLightGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a91pickup NUM=1 TEXTURE=9aGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a91pickup NUM=2 TEXTURE=9aDarkGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a91pickup NUM=3 TEXTURE=9aBlackAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a91pickup NUM=5 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=9a91pickup NUM=6 TEXTURE=BlackMaskTex

//================================
// 3rd Person
//================================

#exec MESH IMPORT MESH=9a913rd ANIVFILE=MODELS\9a913rd2_a.3d DATAFILE=MODELS\9a913rd2_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=9a913rd X=-130 Y=0 Z=-100 PITCH=17 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=9a913rd SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=9a913rd SEQ=9a913rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=9a913rd MESH=9a913rd
//#exec MESHMAP SCALE MESHMAP=9a913rd X=0.008594025 Y=0.008594025 Z=0.008594025
#exec MESHMAP SCALE MESHMAP=9a913rd X=0.01031283 Y=0.01031283 Z=0.01031283

#exec MESHMAP SETTEXTURE MESHMAP=9a913rd NUM=0 TEXTURE=9aLightGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a913rd NUM=1 TEXTURE=9aGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a913rd NUM=2 TEXTURE=9aDarkGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a913rd NUM=3 TEXTURE=9aBlackAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a913rd NUM=5 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=9a913rd NUM=6 TEXTURE=BlackMaskTex


//================================
// 1st Person
//================================

#exec MESH IMPORT MESH=9a911st ANIVFILE=MODELS\9a91_a.3d DATAFILE=MODELS\9a91_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=9a911st X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=9a911st SEQ=All             	STARTFRAME=0 	NUMFRAMES=1
#exec MESH SEQUENCE MESH=9a911st SEQ=9a911st 		STARTFRAME=0 	NUMFRAMES=20
#exec MESH SEQUENCE MESH=9a911st SEQ=Select 		STARTFRAME=0 	NUMFRAMES=4 		RATE=9 GROUP=Select
#exec MESH SEQUENCE MESH=9a911st SEQ=Shoot		STARTFRAME=4	NUMFRAMES=4		RATE=9
#exec MESH SEQUENCE MESH=9a911st SEQ=Down		STARTFRAME=8	NUMFRAMES=4		RATE=8
#exec MESH SEQUENCE MESH=9a911st SEQ=ReloadBegin	STARTFRAME=12	NUMFRAMES=3		RATE=6
#exec MESH SEQUENCE MESH=9a911st SEQ=Reload		STARTFRAME=15	NUMFRAMES=2		RATE=1.428
#exec MESH SEQUENCE MESH=9a911st SEQ=ReloadEnd		STARTFRAME=17	NUMFRAMES=3		RATE=10
#exec MESH SEQUENCE MESH=9a911st SEQ=Idle1		STARTFRAME=4	NUMFRAMES=1		RATE=2
#exec MESH SEQUENCE MESH=9a911st SEQ=Idle2		STARTFRAME=4	NUMFRAMES=1		RATE=2
#exec MESH SEQUENCE MESH=9a911st SEQ=Idle3		STARTFRAME=4	NUMFRAMES=1		RATE=2
#exec MESH SEQUENCE MESH=9a911st SEQ=Still		STARTFRAME=4	NUMFRAMES=1		RATE=2

#exec MESHMAP NEW   MESHMAP=9a911st MESH=9a911st
#exec MESHMAP SCALE MESHMAP=9a911st X=0.008594025 Y=-0.008594025 Z=0.008594025
//#exec MESHMAP SCALE MESHMAP=9a913rd X=0.01031283 Y=0.01031283 Z=0.01031283

#exec MESHMAP SETTEXTURE MESHMAP=9a911st NUM=0 TEXTURE=9aLightGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a911st NUM=1 TEXTURE=9aGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a911st NUM=2 TEXTURE=9aDarkGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a911st NUM=3 TEXTURE=9aBlackAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a911st NUM=4 TEXTURE=9aDarkGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=9a911st NUM=5 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=9a911st NUM=6 TEXTURE=BlackMaskTex

#exec MESH NOTIFY MESH=9a911st SEQ=Shoot	TIME=0.05	FUNCTION=SwapMuzzleFlashTexture


simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		bHasLaser = False;
	}
}

function processtracehit(actor other, vector hitlocation, vector hitnormal, vector x, vector y, vector z)
{
 local int H1, H2, H3, H4, H5;
 local name damageType;
 
 H1 = Pawn(Other).HealthLegLeft;
 H2 = Pawn(Other).HealthLegRight;
 H3 = Pawn(Other).HealthArmLeft;
 H4 = Pawn(Other).HealthArmRight;
 H5 = Pawn(Other).HealthTorso; 
 
 damageType = WeaponDamageType();
 
 Super.Processtracehit(Other, hitLocation, hitNormal, x, y, z);
 
 //Bonus Limb Damage, though it wont apply for arms in MP. (causes upped torso damage too)
 
 if ( (H1 > Pawn(Other).HealthLegLeft) || (h2 > Pawn(other).HealthLegRight) || ( ((h3 > Pawn(other).HealthArmLeft) || (h4 > Pawn(other).HealthArmRight)) && (H5 <= Pawn(Other).HealthTorso)) )
 {
  Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 1000.0*X, damageType);
 }
}



simulated function PlaySelectiveFiring()
{
	local Pawn aPawn;
	local float rnd;
	local Name anim;

	anim = 'Shoot';

	if (bHandToHand)
	{
		rnd = FRand();
		if (rnd < 0.33)
			anim = 'Attack';
		else if (rnd < 0.66)
			anim = 'Attack2';
		else
			anim = 'Attack3';
	}

	if (( Level.NetMode == NM_Standalone ) || ( DeusExPlayer(Owner) == DeusExPlayer(GetPlayerPawn())) )
	{
		if (bAutomatic)
			LoopAnim(anim,2.5, 0.1);
		else
			PlayAnim(anim,2.5,0.1);
	}
	else if ( Role == ROLE_Authority )
	{
		for ( aPawn = Level.PawnList; aPawn != None; aPawn = aPawn.nextPawn )
		{
			if ( aPawn.IsA('DeusExPlayer') && ( DeusExPlayer(Owner) != DeusExPlayer(aPawn) ) )
			{
				// If they can't see the weapon, don't bother
				if ( DeusExPlayer(aPawn).FastTrace( DeusExPlayer(aPawn).Location, Location ))
					DeusExPlayer(aPawn).ClientPlayAnimation( Self, anim, 0.25, bAutomatic );
			}
		}
	}
}

simulated function SwapMuzzleFlashTexture()
{
   if (!bHasMuzzleFlash)
      return;

	if (Frand() < 0.5)
		MultiSkins[5] = Texture'DERP9aCusMuz'; //fuckin thing cant start with a number
	else					       //so fuck it and throw in derp.
		MultiSkins[6] = Texture'DERP9aCusMuz';

	MuzzleFlashLight();
	SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture()
{
	MultiSkins[5] = Texture'BlackMaskTex';
	MultiSkins[6] = Texture'BlackMaskTex';
}

defaultproperties
{
     bKnockBack=True
     KnockBackAmount=20
     MaxRicochets=2
     PenetrationPower=23
     BaseAccuracy=0.785000
     mpBaseAccuracy=0.785000
     LowAmmoWaterMark=20
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     bAutomatic=True
     ShotTime=0.250000
     reloadTime=2.250000
     HitDamage=6
     bHasScope=True
     bCanHaveLaser=True
     bHasLaser=True
     bCanHaveSilencer=True
     recoilStrength=0.750000
     MinWeaponAcc=0.200000
     mpReloadTime=2.250000
     mpHitDamage=6
     mpAccurateRange=2400
     mpMaxRange=2400
     mpReloadCount=20
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'MarkistanCity.MSCAmmo9mm'
     ReloadCount=20
     PickupAmmoCount=100
     bInstantHit=True
     FireOffset=(X=-16.000000,Y=15.500000,Z=15.000000)
     shakemag=200.000000
     FireSound=Sound'SMGFire'
     AltFireSound=Sound'SMGReloadEnd'
     CockingSound=Sound'SMGReload'
     SelectSound=Sound'DeusExSounds.Weapons.AssaultGunSelect'
     InventoryGroup=248
     ItemName="9A-91 Compact Assault Rifle"
     ItemArticle="a"
     PlayerViewOffset=(X=16.000000,Y=-13.000000,Z=-12.500000)
     PlayerViewMesh=LodMesh'9a911st'
     PickupViewMesh=LodMesh'9a91Pickup'
     ThirdPersonMesh=LodMesh'9a913rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'BeltIcon9a91'
     largeIcon=Texture'InventoryIcon9a91'
     largeIconWidth=96
     largeIconHeight=48
     invSlotsX=2
     invSlotsY=1
     Description="The 9A-91 russian compact assault rifle is a relatively simple weapon. It runs on 9mm and hold 20 rounds a clip using a standard magazine."
     beltDescription="9A91"
     Mesh=LodMesh'9a91Pickup'
     CollisionRadius=15.000000
     CollisionHeight=1.100000
     Mass=30.000000
     Texture=Texture'ReflectionMapTex2'
}
